-- Macro_Scripts File
-- Purpose:  define action for each creatable Compound objects to hook up to the create main menu (or quads)

/*
Revision History
	July 6 2006, Pierre-Felix Breton
		Added the Pro Boolean to 3dsmax 9

	12 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macro file can be shared with all Discreet products

	24 Mai 2003: Pierre-felix Breton
		created for 3ds MAX 6
*/

-- Macro Scripts for Objects
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK



----------------------------------------------------------------------------------------------------
macroScript Terrain 
category:~TERRAIN_CATEGORY~ 
internalCategory:"Objects Compounds" 
tooltip:~TERRAIN_TOOLTIP~ 
buttontext:~TERRAIN_BUTTONTEXT~ 
Icon:#("Compound",4)
(
   on execute do StartObjectCreation Terrain 
   on isChecked return (mcrUtils.IsCreating Terrain)
   on isEnabled return okToCreate Terrain

)

----------------------------------------------------------------------------------------------------
macroScript Morph 
category:~MORPH_CATEGORY~ 
internalCategory:"Objects Compounds" 
tooltip:~MORPH_TOOLTIP~ 
buttontext:~MORPH_BUTTONTEXT~ 
Icon:#("Compound",1)
(
   on execute do StartObjectCreation Morph
   on isChecked return (mcrUtils.IsCreating Morph)
   on isEnabled return okToCreate Morph

)

----------------------------------------------------------------------------------------------------
macroScript Conform 
category:~CONFORM_CATEGORY~ 
internalCategory:"Objects Compounds" 
tooltip:~CONFORM_TOOLTIP~ 
buttontext:~CONFORM_BUTTONTEXT~ 
Icon:#("Compound",2)
(
   on execute do StartObjectCreation Conform
   on isChecked return (mcrUtils.IsCreating Conform)
   on isEnabled return okToCreate Conform
)

----------------------------------------------------------------------------------------------------
macroScript ShapeMerge 
            category:~SHAPEMERGE_CATEGORY~ 
            internalCategory:"Objects Compounds" 
            tooltip:~SHAPEMERGE_TOOLTIP~ 
            buttontext:~SHAPEMERGE_BUTTONTEXT~ 
            Icon:#("Compound",3)
(
   on execute do StartObjectCreation ShapeMerge
   on isChecked return (mcrUtils.IsCreating ShapeMerge)
   on isEnabled return (okToCreate ShapeMerge)
)

----------------------------------------------------------------------------------------------------
macroScript Loft 
            category:~LOFT_CATEGORY~ 
            internalCategory:"Objects Compounds" 
            tooltip:~LOFT_TOOLTIP~ 
            buttontext:~LOFT_BUTTONTEXT~ 
            Icon:#("Compound",8)
(
   on execute do StartObjectCreation Loft
   on isChecked return (mcrUtils.IsCreating Loft)
   on isEnabled return okToCreate Loft

)

----------------------------------------------------------------------------------------------------
macroScript Scatter 
            category:~SCATTER_CATEGORY~ 
            internalCategory:"Objects Compounds" 
            tooltip:~SCATTER_TOOLTIP~ 
            buttontext:~SCATTER_BUTTONTEXT~ 
            Icon:#("Compound",5)
(
   on execute do StartObjectCreation Scatter
   on isChecked return (mcrUtils.IsCreating Scatter)
   on isEnabled return okToCreate Scatter

)

----------------------------------------------------------------------------------------------------
macroScript Connect 
            category:~CONNECT_CATEGORY~ 
            internalCategory:"Objects Compounds" 
            tooltip:~CONNECT_TOOLTIP~ 
            buttontext:~CONNECT_BUTTONTEXT~ 
            Icon:#("Compound",6)
(
    on execute do StartObjectCreation Connect
   on isChecked return (mcrUtils.IsCreating Connect)
   on isEnabled return okToCreate Connect

)

----------------------------------------------------------------------------------------------------
macroScript Boolean 
            category:~BOOLEAN_CATEGORY~ 
            internalCategory:"Objects Compounds" 
            tooltip:~BOOLEAN_TOOLTIP~ 
            buttontext:~BOOLEAN_BUTTONTEXT~ 
            Icon:#("Compound",7)
(
   on execute do StartObjectCreation Boolean3
   on isChecked return (mcrUtils.IsCreating Boolean3)
   on isEnabled return okToCreate Boolean3

)

----------------------------------------------------------------------------------------------------
macroScript BlobMesh 
            category:~BLOBMESH_CATEGORY~ 
            internalCategory:"Objects Compounds" 
            tooltip:~BLOBMESH_TOOLTIP~ 
            buttontext:~BLOBMESH_BUTTONTEXT~ 
            --Icon:#("Compound",5)
(
   on execute do StartObjectCreation BlobMesh 
   on isChecked return (mcrUtils.IsCreating BlobMesh )
   on isEnabled return okToCreate BlobMesh 

)

----------------------------------------------------------------------------------------------------
macroScript Mesher 
            category:~MESHER_CATEGORY~ 
            internalCategory:"Objects Compounds" 
            tooltip:~MESHER_TOOLTIP~ 
            buttontext:~MESHER_BUTTONTEXT~ 
            --Icon:#("Compound",5)
(
   on execute do StartObjectCreation Mesher 
   on isChecked return (mcrUtils.IsCreating Mesher )
   on isEnabled return okToCreate Mesher 

)

----------------------------------------------------------------------------------------------------
macroScript ProBoolean 
            category:~PROBOOLEAN_CATEGORY~ 
            internalCategory:"Objects Compounds" 
            tooltip:~PROBOOLEAN_TOOLTIP~ 
            buttontext:"ProBoolean" 
            Icon:#("PowerBoolean",7)
(
   on execute do StartObjectCreation ProBoolean
   on isChecked return (mcrUtils.IsCreating ProBoolean)
   on isEnabled return okToCreate ProBoolean
)

----------------------------------------------------------------------------------------------------
macroScript Procutter
            category:~PROCUTTER_CATEGORY~ 
            internalCategory:"Objects Compounds" 
            tooltip:~PROCUTTER_TOOLTIP~ 
            buttontext:"ProCutter" 
            Icon:#("PowerBoolean",9)
(
   on execute do StartObjectCreation ProCutter
   on isChecked return (mcrUtils.IsCreating ProCutter)
   on isEnabled return okToCreate ProCutter
)


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQAhDeecucCztQkw2GwRx7lUZsq70/PJa4ey
-- EUHdkzaNwJhsfZblJezG5rVfZOKRjJcuqMtKURFycl3TekLm4LG1N4NkiReYMiql
-- /tn+kVRT6dfCYZhFGY4QwCxd0r6q7ux/td5kqLkVE/LKzVa2ld5qa3e7Pd0NLsVw
-- rLV2oLu0UnqFS7F/v41xOQigrwwnkNHLoWfZe1n4WabM1P6Dq6WH3EFi5LrKNLip
-- f1FvMWVOXZ/NcsVazTb6eEODAAPhGn2DRtFKvtTcqTNq+SOCJrYbj2R831e4MMMz
-- chWbzHooNAD5ROPA7pBUWm2EUKIAQLPdsM2BOHL2EAwn4T/1jDEX
-- -----END-SIGNATURE-----